﻿using System;
using System.Collections.Generic;
using GenericIntegrationLayer.Controllers.EntityControllers;
using RnD.BusinessLayer.Interfaces.Factory;
using RnD.BusinessLayer.Interfaces.Model;
using RnD.Common.Enums;

namespace PropfitGroup.GilTest
{
    internal class Program
    {
        public static void Main(string[] args)
        {
            
            var serviceLocator = ServiceLocator.ServiceLocator.Instance();
            var aConnectionName = "RDnLContext2";
            var aEventManagerType = (int)EventManagerType.Asynchronous;
            var str = "en-US";
            var aBrowserGuid = new Guid();
            var aDataLanguage = str;
            var bof = serviceLocator.GetFactory<IEventAwareObjectFactory>(aConnectionName,
                DatabaseAccessMode.ConfigurationalObjectsFullReadAccess, (EventManagerType)aEventManagerType,
                aTaskType: "scCreate", aBrowserGuid: aBrowserGuid, aDataLanguage: aDataLanguage);

            #region MyRegion

            var sample = bof.Sample.GetSample(30001);
            
            // var sample = api.Sample.GetSample(30001);
            //
            //
            //     api.BusinessObjectFactory.SaveChanges();
            //
            //     List<TaskKeyDTO> taskKeys = api.BusinessObjectFactory.TaskKeys.GetAll("sccreate", 61, 5);
            //
            
            
            List<TaskFilterDTO> taskFilterDTOs = new List<TaskFilterDTO>
            {
                new TaskFilterDTO
                {
                    Field = "ACTIVE@RndvSt",
                    Operator = "Contains",
                    Value = "1"
                },
                new TaskFilterDTO
                {
                    Field = "DESCRIPTION@RndvSt",
                    Operator = "Contains",
                    Value = "ЛУКОЙЛ АВАНГАРД ЭКСТРА 10W-40"
                },
                new TaskFilterDTO
                {
                    Field = "1000000@RndvStLo",
                    Operator = "Contains",
                    Value = "Perm"
                },
                new TaskFilterDTO
                {
                    Field = "21@RndvStAu",
                    Operator = "Contains",
                    Value = "ПК - Приёмочный контроль"
                },
                new TaskFilterDTO
                {
                    Field = "SHORT_DESC@RndvSt",
                    Operator = "Contains",
                    Value = "FP7662-AC"
                },
                new TaskFilterDTO
                {
                    Field = "43@RndvStAu",
                    Operator = "Contains",
                    Value = "Канистра 5л"
                }
            };
            
            SampleFullDTO sampleFullDto = bof.Sample.Create(
                sample.ST,
                sample.ST_VERSION,
                taskFilterDTOs);
            
            bof.SaveChanges();

            
            
            #endregion
            Console.WriteLine();
        }
    }
    
}