﻿using System;
using System.Collections.Generic;
using Ninject;
using Ninject.Extensions.Xml;
using Ninject.Modules;
using Ninject.Parameters;
using RnD.API;
using RnD.BusinessLayer.EF;
using RnD.BusinessLayer.EF.Factory;
using RnD.BusinessLayer.EF.Interfaces;
using RnD.BusinessLayer.Interfaces.Factory;
using RnD.BusinessLayer.Interfaces.Model;
using RnD.Common.Enums;
using RnD.Common.TimeZone;
using RnD.EventManager.Configuration;
using RnD.Model;
using RnD.Model.EF;
using RnD.Model.Interfaces;
using Siemens.OpcenterRDnLLibrary.LifeCycles.PQC.Conditions;
using IParameter = Ninject.Parameters.IParameter;

namespace ProfitGroup.ApiInitializer
{
    internal class Program
    {
        public static void Main(string[] args)
        {
            // var licenses = (IRnDSuiteLicenses) LicenseManager.TryGrant("LLK-DEV\\\\OpcenterRDnL", "WSDualHttpBinding_IServerLicenseChecker", false);

            var aConnectionName = "OpcenterRDnL";

            var kernel = (IKernel)new StandardKernel((INinjectSettings)new NinjectSettings()
            {
                LoadExtensions = false
            }, new INinjectModule[1]
            {
                (INinjectModule)new XmlExtensionModule()
            });
            kernel.Load(
                @"C:\Users\SergeyR\RiderProjects\ProfitGroup.ApiInitializer\ProfitGroup.ApiInitializer\bin\Debug\BusinessLayerIoCSupport\serviceLocatorConfiguration.xml");
            var aEventManagerType = EventManagerType.Synchronous;
            var aTask = "";
            var aTaskType = "scCreate";
            var aBrowserGuid = default(Guid);
            var aUseDataLanguagePref = NullableBool.Undefined;
            string aDataLanguage = null;
            string aUserAppLanguagePref = null;
            TimeZoneId aClientTimeZoneId = null;
            var aIsGsmSession = false;
            string aSourceConnectionName = null;
            var aDatabaseAccessMode = DatabaseAccessMode.ConfigurationalObjectsFullReadAccess;

            var bof = kernel.Get<IEventAwareObjectFactory>(
                (IParameter)new ConstructorArgument(nameof(aConnectionName), aConnectionName),
                new ConstructorArgument(nameof(aDatabaseAccessMode), aDatabaseAccessMode),
                new ConstructorArgument(nameof(aEventManagerType), aEventManagerType),
                new ConstructorArgument(nameof(aTask), aTask),
                new ConstructorArgument(nameof(aTaskType), aTaskType),
                new ConstructorArgument(nameof(aBrowserGuid), aBrowserGuid),
                new ConstructorArgument(nameof(aUseDataLanguagePref), aUseDataLanguagePref),
                new ConstructorArgument(nameof(aDataLanguage), aDataLanguage),
                new ConstructorArgument(nameof(aUserAppLanguagePref), aUserAppLanguagePref),
                new ConstructorArgument("aTimeZoneId", aClientTimeZoneId),
                new ConstructorArgument(nameof(aIsGsmSession), aIsGsmSession),
                new ConstructorArgument(nameof(aSourceConnectionName), aSourceConnectionName));

            List<TaskFilterDTO> taskFilterDTOs = new List<TaskFilterDTO>
            {
                new TaskFilterDTO
                {
                    Field = "ACTIVE@RndvSt",
                    Operator = "Contains",
                    Value = "1"
                },
                new TaskFilterDTO
                {
                    Field = "DESCRIPTION@RndvSt",
                    Operator = "Contains",
                    Value = "ЛУКОЙЛ АВАНГАРД ЭКСТРА 10W-40"
                },
                new TaskFilterDTO
                {
                    Field = "1000000@RndvStLo",
                    Operator = "Contains",
                    Value = "Perm"
                },
                new TaskFilterDTO
                {
                    Field = "21@RndvStAu",
                    Operator = "Contains",
                    Value = "ПК - Приёмочный контроль"
                },
                new TaskFilterDTO
                {
                    Field = "SHORT_DESC@RndvSt",
                    Operator = "Contains",
                    Value = "FP7662-AC"
                },
                new TaskFilterDTO
                {
                    Field = "43@RndvStAu",
                    Operator = "Contains",
                    Value = "Канистра 5л"
                },
            };

            var sample = bof.Sample.GetSample(30001);

            Console.WriteLine("Creating sample...");
            SampleFullDTO sampleFullDto = bof.Sample.Create(
                sample.ST,
                sample.ST_VERSION,
                taskFilterDTOs);

            bof.SaveChanges();
            
            var api = new API(new BusinessObjectFactory((ISession<RnDConnection>)bof.FactorySession));
            
            var createdSample = new Sample(sampleFullDto, api);
            Console.WriteLine(createdSample.Status);
            
            bof.Dispose();
            
            AnyParameterOrMethodNotExecuted

            #region Рабочий код

            //
            // Console.WriteLine("Initialize...");
            // var session = SessionFactoryLocator.Factory.Create(
            //     "RDnLContext2",
            //     DatabaseAccessMode.ConfigurationalObjectsFullReadAccess,
            //     aDataLanguage: "ru-RU", // "ru-RU"); // "en-US"
            //     aUseDataLanguagePref: NullableBool.False, aTimeZoneId: null);
            //
            // var api = session.CustomizationObjectFactory.API as API;
            // var eventManagerAPI = session.CustomizationObjectFactory.EventManagerAPI;
            //
            // var test = EventManagerConfiguration.Instance;
            //
            // try
            // {
            //     #region MyRegion
            //
            //     // var specification = api.Request.CreateRequest("Climate1");
            //     // var newSample = api.Sample.CreateSample("ST-Box-Volume");
            //     //newSample = api.Sample.CreateSample("ST-Box-Volume");
            //
            //     //var attribute = api.GetAttribute("AENNR");
            //
            //     //api.Sample.AssignAttribute(newSample, attribute);
            //
            //     //var lc = newSample.LifeCycleDescription;
            //     //var sampletest = api.Sample.GetSample("SC20230824-1");
            //
            //     //var status = sampletest.Status ?? 0;
            //     //var statustest = newSample.Status;
            //     //var testAttributes = newSample.Attributes;
            //
            //     //api.Sample.ChangeStatus(newSample, status);
            //
            //     //newSample = api.Sample.
            //     //var attribute = api.GetAttribute("AENNR");
            //     //api.Sample.AssignAttribute(newSample, attribute);
            //
            //     //var status = api.GetStatusID("New");
            //
            //     //session.Context.SaveChanges();
            //     //api.Sample.ChangeStatus(newSample, status.First()); 
            //
            //     //var tasks = api.BusinessObjectFactory.TaskDefinition.GetTaskTypes().Select(c => c.TaskType);
            //     //var tasks2 = api.BusinessObjectFactory.TaskDefinition.GetActiveVersion("sccreate", 61);
            //
            //     #endregion
            //     #region MyRegion
            //     //var taskFilterDTOs = taskKeys.Select(c => new TaskFilterDTO
            //     //{
            //     //    ColumnID = c.ColumnID,
            //     //    TaskId = c.Task,
            //     //    Sequence = c.Sequence,
            //     //    Operator = c.Operator,
            //     //    ColumnType = c.ColumnType,
            //     //    Value = string.IsNullOrEmpty(c.DefaultValue) ? GetValue(c) : c.DefaultValue,
            //     //    ValueType = c.ValueListType.ToString(),
            //
            //     //}).ToList(); 
            //     #endregion
            //
            //     var sample = api.Sample.GetSample(30001);
            //
            //
            //     api.BusinessObjectFactory.SaveChanges();
            //
            //     List<TaskKeyDTO> taskKeys = api.BusinessObjectFactory.TaskKeys.GetAll("sccreate", 61, 5);
            //
            //
            //     List<TaskFilterDTO> taskFilterDTOs = new List<TaskFilterDTO>
            //     {
            //         new TaskFilterDTO
            //         {
            //             Field = "ACTIVE@RndvSt",
            //             Operator = "Contains",
            //             Value = "1"
            //         },
            //         new TaskFilterDTO
            //         {
            //             Field = "DESCRIPTION@RndvSt",
            //             Operator = "Contains",
            //             Value = "ЛУКОЙЛ АВАНГАРД ЭКСТРА 10W-40"
            //         },
            //         new TaskFilterDTO
            //         {
            //             Field = "1000000@RndvStLo",
            //             Operator = "Contains",
            //             Value = "Perm"
            //         },
            //         new TaskFilterDTO
            //         {
            //             Field = "21@RndvStAu",
            //             Operator = "Contains",
            //             Value = "ПК - Приёмочный контроль"
            //         },
            //         new TaskFilterDTO
            //         {
            //             Field = "SHORT_DESC@RndvSt",
            //             Operator = "Contains",
            //             Value = "FP7662-AC"
            //         },
            //         new TaskFilterDTO
            //         {
            //             Field = "43@RndvStAu",
            //             Operator = "Contains",
            //             Value = "Канистра 5л"
            //         },
            //     };
            //
            //
            //     var st = sample.SampleType;
            //
            //     using (var bof = api.BusinessObjectFactory)
            //     {
            //         try
            //         {
            //             Console.WriteLine("Creating sample...");
            //             SampleFullDTO sampleFullDto = bof.Sample.Create(
            //                 sample.SampleType,
            //                 sample.SampleTypeVersion,
            //                 taskFilterDTOs);
            //
            //             var newSample = new Sample(sampleFullDto, api);
            //             
            //             Console.WriteLine("Update life cycle");
            //             api.EvaluateLifecycle(newSample);
            //
            //             foreach (var pg in newSample.ParameterGroups)
            //             {
            //                 api.EvaluateLifecycle(pg);
            //                 foreach (var pa in pg.Parameters)
            //                 {
            //                     api.EvaluateLifecycle(pa);
            //                     
            //                     foreach (var method in pa.Methods)
            //                         api.EvaluateLifecycle(method);
            //                 
            //                 }
            //             }
            //             
            //             bof.SaveChanges();
            //
            //             // Console.WriteLine("Saving");
            //             // bof.SaveChanges("Создание объекта", false);
            //
            //             //sample.ChangeStatus(8);
            //             //api.Sample.ChangeStatus(newSample, 8, "Создание объекта");
            //
            //
            //             //api.Sample.ChangeStatus(newSample, 8, "Создание объекта");
            //             //newSample.ChangeStatus(8);
            //
            //             //session.Context.SaveChanges();
            //
            //
            //         }
            //         catch (Exception exception)
            //         {
            //             Console.WriteLine(exception);
            //         }
            //     }
            //     #region MyRegion
            //
            //     //api.EvaluateLifecycle(newSample, new EventData());
            //
            //     //api.
            //     // session.CustomizationObjectFactory.AdvancedAPI.Sample
            //     // ISample newSample = api.Sample.CreateSample(sample.SampleType, sample.SampleTypeVersion);
            //     //api.EvaluateLifecycle(newSample, new EventData());
            //
            //     //session.Context.SaveChanges();
            //
            //     //RnD.EventManager.Utils.Utils
            //
            //
            //     //foreach (var attribute in newSample.Attributes)
            //     //{
            //     //    if (attribute.Description != "Product"
            //     //        && attribute.Description != "Type of Testing"
            //     //        && attribute.Description != "Normative Document"
            //     //        && newSample.Attributes.Where(c => c.Description == "Type of packaging").Count() > 1)
            //     //    {
            //     //        api.Sample.RemoveAttribute(newSample, attribute);
            //
            //     //    }
            //
            //     //}
            //
            //     //foreach (var parameter in sample.ParameterGroups)
            //     //{
            //     //    api2.Sample.AssignParameterProfile(
            //     //        newSample, 
            //     //        parameter.ParameterGroup ?? 1, 
            //     //        parameter.ParameterProfileVersion ?? 1, 
            //     //        parameter.Context, 
            //     //        parameter.ContextKey1, 
            //     //        parameter.ContextKey2, 
            //     //        parameter.ContextKey3, 
            //     //        parameter.ContextKey4,
            //     //        parameter.ContextKey5);
            //     //}
            //
            //     //sample.ChangeStatus(8);
            //     //api.Sample.ChangeStatus(newSample, 8, "Создание объекта");
            //
            //
            //     //api.Sample.ChangeStatus(newSample, 8, "Создание объекта");
            //     //newSample.ChangeStatus(8);
            //
            //     //session.Context.SaveChanges(); 
            //
            //     #endregion
            // }
            // catch (Exception ex)
            // {
            //     Console.WriteLine(ex);
            // }

            #endregion
        }


        private static void tryUpdateEventManager(API api, ICustomizationObjectWithLifeCycle newSample)
        {
            int i = 0;
            while (i != 6)
            {
                try
                {
                    api.EvaluateLifecycle(newSample);
                    break;
                }
                catch (Exception ex)
                {
                    i++;
                }
            }
        }
    }
}