﻿using System.Xml.Serialization;

namespace ProfitGroup.NotifyService.Core.Handlers
{
    public static class ContentDeserializer
    {

        public static T? Deserialize<T>(string content, out string message)
        {
            message = string.Empty;
            try
            {

                var serializer = new XmlSerializer(typeof(T));
                using var stringReader = new StringReader(content);

                var data = new StringReader(content);

                return (T)serializer.Deserialize(data)!;
            }
            catch (Exception e)
            {
                message = e.Message;
                return default;
            }

        }

    }
}
