﻿using System.Xml.Serialization;

namespace ProfitGroup.NotifyService.Models
{
    [XmlRoot(ElementName = "Confirmation", Namespace = "")]
    public class Confirmation
    {

        [XmlAttribute(AttributeName = "ObjectType", Namespace = "")]
        public int ObjectType { get; set; }

        [XmlAttribute(AttributeName = "ResponseType", Namespace = "")]
        public string ResponseType { get; set; }

        [XmlAttribute(AttributeName = "ID", Namespace = "")]
        public int ID { get; set; }

        [XmlAttribute(AttributeName = "Version", Namespace = "")]
        public string Version { get; set; }

        [XmlAttribute(AttributeName = "StatusCode", Namespace = "")]
        public string StatusCode { get; set; }

        [XmlAttribute(AttributeName = "StatusText", Namespace = "")]
        public string StatusText { get; set; }

        [XmlAttribute(AttributeName = "WERKS", Namespace = "")]
        public string Werks { get; set; }
    }

    [XmlRoot(ElementName = "MT_Confirmation", Namespace = "http://lukoil.ru/opcenter/ORM")]
    public class MTConfirmation
    {

        [XmlElement(ElementName = "Confirmation", Namespace = "")]
        public Confirmation Confirmation { get; set; }

    }

    [XmlRoot(ElementName = "Body", Namespace = "http://schemas.xmlsoap.org/soap/envelope/")]
    public class Body
    {

        [XmlElement(ElementName = "MT_Confirmation", Namespace = "http://lukoil.ru/opcenter/ORM")]
        public MTConfirmation MTConfirmation { get; set; }
    }

    [XmlRoot(ElementName = "Envelope", Namespace = "http://schemas.xmlsoap.org/soap/envelope/")]
    public class Envelope
    {

        [XmlElement(ElementName = "Header", Namespace = "http://schemas.xmlsoap.org/soap/envelope/")]
        public object Header { get; set; }

        [XmlElement(ElementName = "Body", Namespace = "http://schemas.xmlsoap.org/soap/envelope/")]
        public Body Body { get; set; }
    }

}
