﻿using ProfitGroup.Rdnl.Extensions.Helpers.Api;
using RnD.API;
using RnD.BusinessLayer.Interfaces.Factory;

namespace ProfitGroup.Rdnl.Extensions
{
    public class RDnLManager
    {
        public IEventAwareObjectFactory EventAwareObjectFactory
        {
            get => _eventAwareObjectFactory == null || _eventAwareObjectFactory.IsDisposed
                ? Initialize().EventAwareObjectFactory
                : _eventAwareObjectFactory;
            private set => _eventAwareObjectFactory = value;
        }


        private IEventAwareObjectFactory _eventAwareObjectFactory;
        private readonly string _connectionName;
        private readonly string _taskType;

        public RDnLManager(string connectionName, string taskType)
        {
            _taskType = taskType;
            _connectionName = connectionName;

            Initialize();
        }

        public RDnLManager Initialize()
        {
            EventAwareObjectFactory = ApiInitializer.InitializeFactory(_connectionName, _taskType);
            return this;
        }
    }
}