using NLog;
using NLog.Config;
using ProfitGroup.Rdnl.Extensions;
using ProfitGroup.SampleService.Core.Services;
using RnD.API;
using RnD.BusinessLayer.EF.Factory;
using RnD.BusinessLayer.EF.Interfaces;
using RnD.Model.EF;
using System;
using System.IO;
using System.Web.Http;
using Unity;
using Unity.Injection;
using Unity.Lifetime;
using Unity.WebApi;


namespace ProfitGroup.SampleService
{
    public static class UnityConfig
    {
        public static void RegisterComponents()
        {
            var container = new UnityContainer();

            var loggerConfig = Path.Combine(AppDomain.CurrentDomain.BaseDirectory, "nlog.config");

            LogManager.Setup().LoadConfigurationFromFile(loggerConfig);
            LogManager.Configuration = new XmlLoggingConfiguration(loggerConfig);

            container.RegisterInstance(typeof(ILogger), LogManager.GetCurrentClassLogger());
            // container.RegisterInstance(typeof(RDnLManager), new RDnLManager("OpcenterRDnL", "scCreate").Initialize(), lifetimeManager: new TransientLifetimeManager());

            container.RegisterType<RDnLManager>(
                new TransientLifetimeManager(),
                new InjectionConstructor("OpcenterRDnL", "scCreate")
            );

            container.RegisterType<IKSSSInfoService, KsssInfoService>();
            container.RegisterType<ISampleService, Core.Services.SampleService>();
            container.RegisterInstance(typeof(SampleConfirmationService));

            var manager = container.Resolve<RDnLManager>();

            container.RegisterInstance(typeof(API), new API(new BusinessObjectFactory(aConnection: (ISession<RnDConnection>)manager.EventAwareObjectFactory.FactorySession)));

            GlobalConfiguration.Configuration.DependencyResolver = new UnityDependencyResolver(container);
        }
    }
}