﻿using ProfitGroup.SampleService.Models;
using RnD.Model;
using RnD.Model.EF;
using System.Collections.Generic;
using System.Threading.Tasks;
using ProfitGroup.SampleService.Data.Database.Entities;

namespace ProfitGroup.SampleService.Core.Services
{
    public interface IKSSSInfoService
    {
        Task<ISpecification> FindActiveSpecificationById(decimal specificationId);
        Task<List<RndvSpIi>> GetInfoFieldsByKSSSCode(string ksssCode);

        string GetProductCodeFromSpecificationKSSS(ISpecification specification, out decimal? frameId);

        string GetPackageNameFromSpecificationKSSS(ISpecification specification);

        IEnumerable<string> GetSpecificationLocationName(ISpecification specification);

        Task<S4InspectionTypeMap> MapOperationControl(decimal locationId, decimal? frameId, string inspectonType);

        RndvSt GetSampleType(string productCode, string operationControlName, string package, string stage,
            decimal plantId);
        Task<RndvLo> GetPlantByName(string plant);
        Task<SiemtControlTypes> GetControlTypeByCode(string controlTypeCode);
    }
}