﻿using System.Text;

namespace ProfitGroup.SampleNotifyService.Core.Handlers
{
    public static class BodyParser
    {

        /// <summary>
        ///  Получение тело из POST запроса
        /// </summary>
        /// <param name="request">Http запросы</param>
        /// <returns>Тело запроса</returns>
        public static async Task<string> ParseBodyAsync(this HttpRequest request)
        {
            using var reader = new StreamReader(request.Body, Encoding.UTF8);

            return await reader.ReadToEndAsync();
        }

    }
}
