﻿using ProfitGroup.SampleNotifyService.Data.Core.Data.Entities;

namespace ProfitGroup.SampleNotifyService.Services;

public interface INotifyService
{
    /// <summary>
    /// Получение актуальной интеграционной инфокарты для спецификации 
    /// </summary>
    /// <param name="specificationId">SP параметр спецификации</param>
    /// <param name="specificationVersion">SP_VERSION параметр спецификации</param>
    /// <param name="locationId">Id локации, от которой отправляется изменение</param>
    /// <returns>Актуальная интеграционная инфокарта спецификации</returns>
    Task<RndtSpIc?> GetSpecificationInfoCardAsync(int specificationId, int specificationVersion, int locationId);

    /// <summary>
    /// Обновление параметров интеграционной инфокарты для спецификации
    /// </summary>
    /// <param name="infoCard">Инфокарта спецификация, параметры которой необходимо обновить</param>
    /// <param name="updateParams">Ключ значение, где ключ - наименование параметра, а значение - данные необходимые подставить</param>
    /// <returns>True - если обновление параметров прошло успешно, в противном случае - False</returns>
    Task<bool> UpdateSpecificationInfoCardAsync(RndtSpIc infoCard, Dictionary<string, string> updateParams);

    /// <summary>
    /// Получение актуального параметра спецификации по наименованию
    /// </summary>
    /// <param name="attributeName">Наименование параметра</param>
    /// <returns>Актуальный параметр спецификации</returns>
    Task<RndtAu?> GetActiveSpecificationAttributeAsync(string attributeName);

    /// <summary>
    /// Получение спецификации
    /// </summary>
    /// <param name="specificationId">Id спецификации</param>
    /// <param name="specificationVersion">Версия спецификации</param>
    /// <returns>Спецификациия по заданным параметрам</returns>
    Task<RndtSp?> GetSpecificationAsync(int specificationId, int specificationVersion);

    /// <summary>
    /// Обновление/Создание атрибута спецификации
    /// </summary>
    /// <param name="specification">Объект спецификации</param>
    /// <param name="actualSpecificationAttribute">Актуальаный атрибут спецификации</param>
    /// <param name="value">Записываемое значение в атрибут</param>
    /// <returns>True - если обновление параметров прошло успешно, в противном случае - False</returns>
    Task<bool> UpdateAttributeAsync(RndtSp specification, RndtAu actualSpecificationAttribute, string value);

    /// <summary>
    /// Получение пробы
    /// </summary>
    /// <param name="sampleId"></param>
    /// <returns>Проба по указанному Id</returns>
    Task<RndtSc?> GetSampleAsync(int sampleId);

    /// <summary>
    /// Получение актуальной интеграционной инфокарты пробы
    /// </summary>
    /// <param name="sampleId">Уникальный идентификатор пробы</param>
    /// <returns></returns>
    Task<RndtScIc?> GetSampleInfoCardAsync(int sampleId);

    /// <summary>
    /// Обновление параметров интеграционной инфокарты для пробы
    /// </summary>
    /// <param name="infoCard">Инфокарта пробы, параметры которой необходимо обновить</param>
    /// <param name="updateParams">Ключ значение, где ключ - наименование параметра, а значение - данные необходимые подставить</param>
    /// <returns>True - если обновление параметров прошло успешно, в противном случае - False</returns>
    Task<bool> UpdateSampleInfoCardAsync(RndtScIc infoCard, Dictionary<string, string> updateParams);

    /// <summary>
    /// Сохраняет логи касаемые метода в базу данных
    /// </summary>
    /// <param name="methodId">Уникальный идентификатор</param>
    /// <param name="methodVersion">Версия метода</param>
    /// <param name="statusCode">Код запроса успешный/неуспешный</param>
    /// <param name="statusText">Сообщение запроса</param>
    /// <returns></returns>
    Task<bool> SaveMethodLog(decimal methodId, decimal methodVersion, string statusCode, string statusText);
    
    /// <summary>
    /// Сохраняет логи касаемые параметра в базу данных
    /// </summary>
    /// <param name="parameterId">Уникальный идентификатор</param>
    /// <param name="parameterVersion">Версия параметра</param>
    /// <param name="statusCode">Код запроса успешный/неуспешный</param>
    /// <param name="statusText">Сообщение запроса</param>
    /// <returns></returns>
    Task<bool> SaveParameterLog(decimal parameterId, decimal parameterVersion, string statusCode, string statusText);
    
}
