﻿namespace ProfitGroup.SampleService.Core.Services
{
    /// <summary>
    /// Предоставляет сервис для определения упаковки по значению диапазона.
    /// </summary>
    public class DetectPackageServiceByRangeValue
    {
        /// <summary>
        /// Определяет упаковку на основе переданных значений диапазона и текущего значения.
        /// </summary>
        /// <param name="minPackageName">Наименование упаковки для минимального значения.</param>
        /// <param name="maxPackageName">Наименование упаковки для максимального значения.</param>
        /// <param name="maxValue">Максимальное значение диапазона.</param>
        /// <param name="currentValue">Текущее значение для определения упаковки.</param>
        /// <returns>Наименование определенной упаковки.</returns>
        public static string Detect(
            string minPackageName,
            string maxPackageName,
            decimal maxValue,
            decimal currentValue)
        {
            return currentValue >= maxValue ? maxPackageName : minPackageName;
        }
    }
}