﻿using ProfitGroup.SampleService.Models;
using RnD.BusinessLayer.Interfaces.Model;
using System.Net;
using System.Threading.Tasks;

namespace ProfitGroup.SampleService.Core.Services
{
    /// <summary>
    /// Предоставляет интерфейс сервиса подтверждения образца, ответственного за отправку сообщений в шину SAP/S4.
    /// </summary>
    public interface ISampleConfirmationService
    {
        /// <summary>
        /// Асинхронно отправляет подтверждение в SAP/S4.
        /// </summary>
        /// <param name="mtInspLot">Экземпляр класса MT_InspLot полученное от SAP/S4.</param>
        /// <param name="sampleFullDto">DTO с полной информацией об образце.</param>
        /// <param name="isSuccessCreated">Флаг успешного создания образца.</param>
        /// <param name="message">Дополнительное сообщение.</param>
        /// <returns>True, если операция отправки подтверждения выполнена успешно, в противном случае - false.</returns>
        Task<(bool isSuccess, HttpStatusCode statusCode, string message)> SendConfirmationToSap(MT_InspLot mtInspLot, SampleFullDTO sampleFullDto, bool isSuccessCreated, string message = null);
    }
}