﻿using ProfitGroup.SampleService.Models;
using RnD.BusinessLayer.Interfaces.Model;
using System.Collections.Generic;
using System.Threading.Tasks;
using RnD.Model;

namespace ProfitGroup.SampleService.Core.Services
{
    /// <summary>
    /// Предоставляет интерфейс сервиса образцов.
    /// </summary>
    public interface ISampleService
    {
        /// <summary>
        /// Получает ключи задач для фильтрации по наименованию завода, наименованию операционного контроля и упаковке или стадии.
        /// </summary>
        /// <param name="plantName">Наименование завода.</param>
        /// <param name="operationControlName">Наименование операционного контроля.</param>
        /// <param name="packageOrStage">Наименование упаковки или стадии.</param>
        /// <returns>Перечисление ключей задач для фильтрации.</returns>
        IEnumerable<TaskFilterDTO> GetTaskKeys(string plantName, string operationControlName, string packageOrStage);

        /// <summary>
        /// Заполняет информационные карточки образца.
        /// </summary>
        /// <param name="sample">Проба</param>
        /// <param name="infoCards">Список настроек информационных карточек.</param>
        /// <param name="plantName">Наименование завода.</param>
        void FillSampleInfoCards(Sample sample, List<InfoCardSetting> infoCards, string plantName);

        /// <summary>
        /// Асинхронно выполняет валидацию образца по его краткому описанию.
        /// </summary>
        /// <param name="shortDescription">Краткое описание образца.</param>
        /// <returns>True, если образец валиден, в противном случае - false.</returns>
        Task<bool> ValidateSample(string shortDescription);

        /// <summary>
        /// Асинхронно отправляет подтверждение образца.
        /// </summary>
        /// <param name="mtInspLot">Экземпляр класса MT_InspLot для отправки.</param>
        /// <param name="sampleFullDto">DTO с полной информацией об образце.</param>
        /// <param name="message">Дополнительное сообщение.</param>
        Task SendConfirmation(MT_InspLot mtInspLot, SampleFullDTO sampleFullDto, string message = null);
    }
}
