﻿using RnD.Model.EF;
using System;

namespace ProfitGroup.SampleService.Models
{
    /// <summary>
    /// Представляет объект передачи данных (DTO) для создания пользовательского образца.
    /// </summary>
    public class CustomSampleCreateDto
    {
        /// <summary>
        /// Получает или устанавливает наименование завода.
        /// </summary>
        public string PlantName { get; set; }

        /// <summary>
        /// Получает или устанавливает код продукта.
        /// </summary>
        public string ProductCode { get; set; }

        /// <summary>
        /// Получает или устанавливает упаковку образца.
        /// </summary>
        public string Package { get; set; }

        /// <summary>
        /// Получает или устанавливает раму спецификации.
        /// </summary>
        public string SpecificationFrame { get; set; }

        /// <summary>
        /// Получает или устанавливает наименование операции контроля.
        /// </summary>
        public string OperationControlName { get; set; }

        /// <summary>
        /// Получает или устанавливает тип образца.
        /// </summary>
        public RndvSt SampleType { get; set; }
    }

    /// <summary>
    /// Представляет атрибут наименования операции контроля.
    /// </summary>
    public class OperationControlNameAttribute : Attribute
    {
        /// <summary>
        /// Получает наименование операции контроля.
        /// </summary>
        public string Name { get; }

        /// <summary>
        /// Инициализирует новый экземпляр атрибута с указанным наименованием.
        /// </summary>
        /// <param name="name">Наименование операции контроля.</param>
        public OperationControlNameAttribute(string name)
        {
            Name = name;
        }
    }
}
