﻿using Microsoft.AspNetCore.Authentication;
using Microsoft.Extensions.Options;
using System.Net.Http.Headers;
using System.Security.Claims;
using System.Text;
using System.Text.Encodings.Web;

namespace ProfitGroup.NotifyService.Core.Auth
{
    public class BasicAuthenticationHandler : AuthenticationHandler<AuthenticationSchemeOptions>
    {
        private ILogger _logger;

        public BasicAuthenticationHandler(IOptionsMonitor<AuthenticationSchemeOptions> options, ILoggerFactory logger, UrlEncoder encoder, ISystemClock clock) : base(options, logger, encoder, clock)
        {
            _logger = logger.CreateLogger<BasicAuthenticationHandler>();
        }

        protected override Task<AuthenticateResult> HandleAuthenticateAsync()
        {
            
            if (!Request.Headers.ContainsKey("Authorization"))
            {
                return Task.FromResult(AuthenticateResult.Fail($"|{Request.Method}| Missing Authorization Header"));
            }

            try
            {
                var authHeader = AuthenticationHeaderValue.Parse(Request.Headers["Authorization"]);
                var credentialBytes = Convert.FromBase64String(authHeader.Parameter);
                var credentials = Encoding.UTF8.GetString(credentialBytes).Split(':');
                var username = credentials[0];
                var password = credentials[1];

                if (IsValidUser(username, password))
                {
                    _logger.LogInformation("Успешная авторизация");
                    
                    var claims = new[] { new Claim(ClaimTypes.Name, username) };
                    var identity = new ClaimsIdentity(claims, Scheme.Name);
                    var principal = new ClaimsPrincipal(identity);
                    var ticket = new AuthenticationTicket(principal, Scheme.Name);

                    return Task.FromResult(AuthenticateResult.Success(ticket));
                }

                _logger.LogInformation($"Произошла ошибка при авторизации. Указан неверный логин или пароль");
                return Task.FromResult(AuthenticateResult.Fail("Incorrect login or password"));
            }
            catch (Exception ex)
            {
                return Task.FromResult(AuthenticateResult.Fail("Error: " + ex.Message));
            }
        }

        private bool IsValidUser(string username, string password)
        {
            // ToDo: Сменить пароль при переносе решения
            
            // APP02
            return username == "S4test" && password == "lMxeTqMIH04R8mCE";
            
            // Productive
            // return username == "S4test" && password == "lMxeTqMIH04R8mCE";
        }
    }
}
