﻿using Ninject;
using Ninject.Extensions.Xml;
using Ninject.Modules;
using Ninject.Parameters;
using RnD.BusinessLayer.Interfaces.Factory;
using RnD.Common.Enums;
using RnD.Common.TimeZone;
using System;
using System.IO;
using System.Web;

namespace ProfitGroup.Rdnl.Extensions.Helpers.Api
{
    public class ApiInitializer
    {
        public static IEventAwareObjectFactory InitializeFactory(string aConnectionName, string taskType)
        {
            var kernel = new StandardKernel(new NinjectSettings()
            {
                LoadExtensions = false
            },
                new INinjectModule[1] { new XmlExtensionModule()
            });

            var configFile = Path.Combine(AppDomain.CurrentDomain.BaseDirectory, @"BusinessLayerIoCSupport\serviceLocatorConfiguration.xml");

            if (!File.Exists(configFile))
            {
                throw new FileNotFoundException("Не удалось найти файл конфигурации", configFile);
            }

            kernel.Load(configFile);

            var aEventManagerType = EventManagerType.Synchronous;
            var aTask = "";
            var aTaskType = taskType; //"scCreate";
            var aBrowserGuid = default(Guid);
            var aUseDataLanguagePref = NullableBool.Undefined;
            string aDataLanguage = null;
            string aUserAppLanguagePref = null;
            TimeZoneId aClientTimeZoneId = null;
            var aIsGsmSession = false;
            string aSourceConnectionName = null;
            var aDatabaseAccessMode = DatabaseAccessMode.ConfigurationalObjectsFullReadAccess;

            return kernel.Get<IEventAwareObjectFactory>(
                new ConstructorArgument(nameof(aConnectionName), aConnectionName),
                new ConstructorArgument(nameof(aDatabaseAccessMode), aDatabaseAccessMode),
                new ConstructorArgument(nameof(aEventManagerType), aEventManagerType),
                new ConstructorArgument(nameof(aTask), aTask),
                new ConstructorArgument(nameof(aTaskType), aTaskType),
                new ConstructorArgument(nameof(aBrowserGuid), aBrowserGuid),
                new ConstructorArgument(nameof(aUseDataLanguagePref), aUseDataLanguagePref),
                new ConstructorArgument(nameof(aDataLanguage), aDataLanguage),
                new ConstructorArgument(nameof(aUserAppLanguagePref), aUserAppLanguagePref),
                new ConstructorArgument("aTimeZoneId", aClientTimeZoneId),
                new ConstructorArgument(nameof(aIsGsmSession), aIsGsmSession),
                new ConstructorArgument(nameof(aSourceConnectionName), aSourceConnectionName));
        }
    }
}
