﻿using RnD.API;
using RnD.Attributes;
using RnD.Common.Enums;
using RnD.Common.Model;
using RnD.Common.Model.ActionBarButtons;
using RnD.CustomFunctionTypes;
using RnD.Model;
using System.Collections.Generic;

namespace ProfitGroup.SampleRequest.Actions
{
    [CustomFunction("ActionSampleRequest")]
    public class SampleRequestAction : AdvancedCustomFunction, ICustomActionBarButton
    {
        public SampleRequestAction(IAPI aAPI) : base(aAPI)
        {

        }

        public ActionBarButtonMetadata GetActionBarButtonMetadata()
        {
            var lResult = new ActionBarButtonMetadata
            {
                Description = "Запросить повторную пробу",
                IconClass = "icon-cmdTestRunAdd24",
                Position = 8,
                DropdownIdentifier = "Повторная проба",
                DropdownIconClass = "icon-cmdTestRunAdd24"
            };

            lResult.IsVisibleWhen.Add(ActionBarButtonVisibility.Sample);

            return lResult;
        }

        public ActionBarButtonResult Execute(List<ICustomizationObject> aCustomisationObject)
        {

            var lResult = new ValidationResult();

            var result = new ActionBarButtonResult
            {
                Message = "Запрос успешно отправлен",
                MessageType = MessageType.Information,
                JsFunction = "console.log('Success')",
                Refresh = false,
            };

            return result;
        }
    }
}