using NLog;
using NLog.Config;
using ProfitGroup.Rdnl.Extensions;
using ProfitGroup.SampleService.Core.Services;
using RnD.API;
using RnD.BusinessLayer.EF.Factory;
using RnD.BusinessLayer.EF.Interfaces;
using RnD.Model.EF;
using System;
using System.Collections.Concurrent;
using System.ComponentModel.DataAnnotations;
using System.IO;
using System.Web.Http;
using ProfitGroup.SampleService.Models;
using Unity;
using Unity.Injection;
using Unity.Lifetime;
using Unity.WebApi;


namespace ProfitGroup.SampleService
{
    public static class UnityConfig
    {
        public static UnityContainer Container;

        public static void RegisterComponents()
        {
            Container = new UnityContainer();

            var loggerConfig = Path.Combine(AppDomain.CurrentDomain.BaseDirectory, "nlog.config");

            LogManager.Setup().LoadConfigurationFromFile(loggerConfig);
            LogManager.Configuration = new XmlLoggingConfiguration(loggerConfig);

            Container.RegisterInstance(typeof(ILogger), LogManager.GetCurrentClassLogger());

            Container.RegisterType<RDnLManager>(
                new TransientLifetimeManager(),
                new InjectionConstructor("OpcenterRDnL", "scCreate")
            );

            Container.RegisterType<IKSSSInfoService, KsssInfoService>();
            Container.RegisterType<ISampleService, Core.Services.SampleService>();
            Container.RegisterInstance(typeof(SampleCreateState), new SampleCreateState(), new SingletonLifetimeManager());
            Container.RegisterInstance(typeof(SampleConfirmationService));
            Container.RegisterSingleton<QueueHandler>();

            var manager = Container.Resolve<RDnLManager>();
            Container.RegisterInstance(typeof(API), new API(new BusinessObjectFactory(aConnection: (ISession<RnDConnection>)manager.EventAwareObjectFactory.FactorySession)));


            var queueHandler = Container.Resolve<QueueHandler>();

            queueHandler.StartProcessing();

            GlobalConfiguration.Configuration.DependencyResolver = new UnityDependencyResolver(Container);
        }
    }
}