﻿using ProfitGroup.SampleService.Models;
using RnD.Model;
using RnD.Model.EF;
using System.Collections.Generic;
using System.Threading.Tasks;
using ProfitGroup.SampleService.Data.Database.Entities;

namespace ProfitGroup.SampleService.Core.Services
{
    /// <summary>
    /// Предоставляет интерфейс сервиса для работы с информацией о КССС.
    /// </summary>
    public interface IKSSSInfoService
    {
        /// <summary>
        /// Асинхронно находит активную спецификацию по идентификатору.
        /// </summary>
        Task<ISpecification> FindActiveSpecificationById(decimal specificationId, decimal sP_VERSION);

        /// <summary>
        /// Асинхронно получает информационные поля по коду КССС.
        /// </summary>
        Task<List<RndvSpIi>> GetInfoFieldsByKSSSCode(string ksssCode);

        /// <summary>
        /// Получает код продукта из спецификации КССС и возвращает идентификатор рамы.
        /// </summary>
        string GetProductCodeFromSpecificationKSSS(ISpecification specification, out decimal? frameId);

        /// <summary>
        /// Получает наименование упаковки из спецификации КССС.
        /// </summary>
        string GetPackageNameFromSpecificationKSSS(ISpecification specification);

        /// <summary>
        /// Получает наименования местоположения из спецификации.
        /// </summary>
        IEnumerable<string> GetSpecificationLocationName(ISpecification specification);

        /// <summary>
        /// Асинхронно выполняет отображение операционного контроля для указанного местоположения, рамы и типа инспекции.
        /// </summary>
        Task<S4InspectionTypeMap> MapOperationControl(decimal locationId, decimal? frameId, string inspectonType);

        /// <summary>
        /// Получает SampleType по коду продукта, наименованию операционного контроля, упаковке, стадии и идентификатору завода.
        /// </summary>
        RndvSt GetSampleType(string productCode, string operationControlName, string package, string stage,
            decimal plantId);

        /// <summary>
        /// Асинхронно получает объект завода по его наименованию.
        /// </summary>
        Task<RndvLo> GetPlantByName(string plant);

        /// <summary>
        /// Асинхронно получает тип контроля по коду контроля.
        /// </summary>
        Task<SiemtControlTypes> GetControlTypeByCode(string controlTypeCode);

        /// <summary>
        /// Асинхронно получает объект завода по его идентификатору.
        /// </summary>
        Task<RndvLo> GetPlantById(decimal plantId);
        /// <summary>
        /// Проверка на существование в системе упаковки с текущим наименованием
        /// </summary>
        /// <param name="package">Наименование упаковки KSSS</param>
        /// <param name="opCenterPackageName">Наименвоание упаковки из Opcenter</param>
        /// <returns></returns>
        bool CheckAndMapPackageName(string package, decimal plantId, out string opCenterPackageName);
        Task<List<RndvSp>> GetActiveSpecificationsFromRange(List<decimal> specificationSp);
    }
}
