﻿using System.Collections.Generic;
using Newtonsoft.Json;

namespace ProfitGroup.SampleService.Models
{
    /// <summary>
    /// Представляет настройки для инфокарт, определяющие значение поля, путь и атрибуты, которые записываются в инфокарту из пакета.
    /// </summary>
    public class InfoCardSetting
    {
        /// <summary>
        /// Получает или устанавливает имя атрибута.
        /// </summary>
        [JsonProperty("Name")] public string Name { get; set; }

        /// <summary>
        /// Получает или устанавливает значение атрибута "Plant".
        /// </summary>
        [JsonProperty("Plant")] public string Plant { get; set; }

        /// <summary>
        /// Получает или устанавливает значение атрибута "Value".
        /// </summary>
        public string Value { get; set; }

        /// <summary>
        /// Получает или устанавливает список путей к полям инфокарты.
        /// </summary>
        [JsonProperty("InfoFieldPaths")] public List<InfoFieldPath> InfoFieldPaths { get; set; }
    }

    /// <summary>
    /// Представляет путь к полю инфокарты, состоящий из имени инфокарты и имени поля.
    /// </summary>
    public class InfoFieldPath
    {
        /// <summary>
        /// Получает или устанавливает имя инфокарты.
        /// </summary>
        [JsonProperty("InfoCard")] public string InfoCard { get; set; }

        /// <summary>
        /// Получает или устанавливает имя поля инфокарты.
        /// </summary>
        [JsonProperty("InfoField")] public string InfoField { get; set; }
    }

    /// <summary>
    /// Представляет настройки приложения, такие как URL подтверждения, логин, пароль и директория подтверждения.
    /// </summary>
    public class Appsettings
    {
        /// <summary>
        /// Получает или устанавливает URL подтверждения.
        /// </summary>
        [JsonProperty("ConfirmationUrl")] public string ConfirmationUrl { get; set; }

        /// <summary>
        /// Получает или устанавливает логин подтверждения.
        /// </summary>
        [JsonProperty("ConfirmationLogin")] public string ConfirmationLogin { get; set; }

        /// <summary>
        /// Получает или устанавливает пароль подтверждения.
        /// </summary>
        [JsonProperty("ConfirmationPassword")] public string ConfirmationPassword { get; set; }

        /// <summary>
        /// Получает или устанавливает директорию подтверждения в формате XML.
        /// </summary>
        [JsonProperty("XmlConfirmationDirectory")]
        public string XmlConfirmationDirectory { get; set; }

        /// <summary>
        /// Получает или устанавливает список настроек инфокарты.
        /// </summary>
        [JsonProperty("InfoCardSettings")] public List<InfoCardSetting> InfoCardSettings { get; set; }
    }
}
