﻿using System.Collections.Generic;
using System.Xml.Serialization;

namespace ProfitGroup.Rdnl.Extensions.Models
{
    /// <summary>
    /// Представляет корневой элемент MT_Confirmation с пространством имен "http://lukoil.ru/opcenter/ORM".
    /// </summary>
    [XmlRoot("MT_Confirmation", Namespace = "http://lukoil.ru/opcenter/ORM")]
    public class MT_Confirmation
    {
        /// <summary>
        /// Получает или устанавливает список подтверждений.
        /// </summary>
        [XmlElement("Confirmation")]
        public List<Confirmation> Confirmations { get; set; }
    }

    /// <summary>
    /// Представляет элемент подтверждения с пространством имен "http://lukoil.ru/opcenter/ORM".
    /// </summary>
    [XmlRoot("Confirmation", Namespace = "http://lukoil.ru/opcenter/ORM")]
    public class Confirmation
    {
        /// <summary>
        /// Получает или устанавливает значение атрибута "ObjectType".
        /// </summary>
        [XmlAttribute]
        public string ObjectType { get; set; }

        /// <summary>
        /// Получает или устанавливает значение атрибута "ResponseType".
        /// </summary>
        [XmlAttribute]
        public string ResponseType { get; set; }

        /// <summary>
        /// Получает или устанавливает значение атрибута "ID".
        /// </summary>
        [XmlAttribute]
        public string ID { get; set; }

        /// <summary>
        /// Получает или устанавливает значение атрибута "Version".
        /// </summary>
        [XmlAttribute]
        public string Version { get; set; }

        /// <summary>
        /// Получает или устанавливает значение атрибута "StatusCode".
        /// </summary>
        [XmlAttribute]
        public string StatusCode { get; set; }

        /// <summary>
        /// Получает или устанавливает значение атрибута "StatusText".
        /// </summary>
        [XmlAttribute]
        public string StatusText { get; set; }
    }
}
