﻿using System;
using System.Collections.Generic;
using System.Data.Entity;
using System.Linq;
using RnD.API;
using RnD.Attributes;
using RnD.Model;
using RnD.Model.EF;
using RnD.Model.FWB;

namespace Actions
{
    [CustomFunction("AddToSpecification", RnD.Common.Enums.CustomFunctionType.CustomAction)]
    public class AddToSpecification : AdvancedCustomFunction, ICustomAction<ICustomContext>
    {
        private SpecificationCodeMask aSpecificationCodeMask { get; set; }

        private string aCreateNewSpecPref { get; set; } = "Create New Specification";
        private string aUpdateSpecPref { get; set; } = "Update Specification";
        private string aPrefTp { get; set; } = "fwb";
        private string aPrefNameSaveToSpec { get; set; } = "fwbSaveToSpec";
        private string aPrefNameFrameNumber { get; set; } = "frameNumber";

        public AddToSpecification(IAPI aAPI) : base(aAPI)
        {
            aSpecificationCodeMask = new SpecificationCodeMask(aAPI);
        }

        public void Execute(ICustomContext aContext)
        {
            var lMaterial = ((IRequest)aContext.Entity).FormulationMaterial;
            var lSaveToSpecPref = DatabaseContext.RndvPref.FirstOrDefault(x => x.PREF_TP == aPrefTp && x.PREF_NAME == aPrefNameSaveToSpec && x.SEQ == 1).PREF_VALUE;
            var userId = API.User.GetUser((decimal)aContext.Event.UserName).ID;
            var rndtContact = DatabaseContext.RndvContact.FirstOrDefault(c => c.CONTACT == userId);
            var userName = string.Join(" ", rndtContact.LAST_NAME, rndtContact.FIRST_NAME, rndtContact.MIDDLE_NAME);

            SaveMaterialToSpecification(lMaterial, lSaveToSpecPref, (IRequest)aContext.Entity, userName);
        }

        public void SaveMaterialToSpecification(IFormulationMaterial aMaterial, string aSaveToSpecPref, IRequest aRequest, string userName)
        {
            // itereate through all the materials 
            foreach (var lMat in aMaterial.Materials)
                SaveMaterialToSpecification(lMat, aSaveToSpecPref, aRequest, userName);

            // check if aMaterial exists in db
            RndvSp lSpec = DatabaseContext.RndvSp.FirstOrDefault(x => x.SP_VALUE == aMaterial.MaterialValue);

            if (aMaterial.Specification == 0 || (aMaterial.ItemChanged == RnD.Common.Enums.NullableBool.True && aSaveToSpecPref == aCreateNewSpecPref))
            {
                var lMaterialNumber = aMaterial.MaterialValue;
                decimal lFrameNumber = 0;
                if (lSpec != null && aSaveToSpecPref == aCreateNewSpecPref)
                {
                    lMaterialNumber = aSpecificationCodeMask.GetCodeMask();
                    aMaterial.MaterialValue = lMaterialNumber;
                    lFrameNumber = lSpec.FR;
                }

                if (lFrameNumber == 0)
                {
                    var rndvPref = DatabaseContext.RndvPref.FirstOrDefault(x => x.PREF_TP == aPrefTp && x.PREF_NAME == aPrefNameFrameNumber && x.SEQ == 1);
                    lFrameNumber = Convert.ToDecimal(rndvPref?.PREF_VALUE);
                }
                var lFrames = DatabaseContext.RndvFr.Where(x => x.FR == lFrameNumber);
                var lFrame = lFrames.ToList().FirstOrDefault(c => c.ACTIVE == RnD.Common.Enums.NullableBool.True);
                if (lFrame == null)
                {
                    Log.Warn($"Frame {lFrameNumber} is not active, cannot create a spec from it!");
                    return;
                }

                var newSpecification = API.Specification.CreateSpecification(lMaterialNumber, aMaterial.Description, lFrame.FR_VALUE, Convert.ToDecimal(lFrame.STYPE), lFrame.SP_LC, new List<Tuple<decimal, string>>());

                aMaterial.ItemChanged = RnD.Common.Enums.NullableBool.False;
                API.FormulaWorkbench.AutoPersistChanges = false;
                API.FormulaWorkbench.LinkToSpecification(aMaterial, newSpecification);
                API.FormulaWorkbench.AutoPersistChanges = true;
                API.FormulaWorkbench.UpdateMaterials(aRequest);
                API.FormulaWorkbench.SaveToSpecification(aMaterial);
                DatabaseContext.SaveChanges();

                #region Custom
                var rndtBomHeader = DatabaseContext.RndvBomHeader.FirstOrDefault(c => c.SP == newSpecification.ID);
                if (!(rndtBomHeader is null))
                {
                    var rndtPref = DatabaseContext.RndvPref.FirstOrDefault(c => c.DESCRIPTION == "Preference for Unit when SaveToSpec");
                    if (!(rndtPref is null))
                    {
                        rndtBomHeader.UOM = rndtPref.PREF_VALUE;
                    }
                    var rndtRqLo = DatabaseContext.RndvRqLo.FirstOrDefault(c => c.RQ == aRequest.ID);
                    if (!(rndtRqLo is null))
                    {
                        rndtBomHeader.LO = (decimal)rndtRqLo.LO;
                    }
                }
                var attribute = newSpecification.Attributes.FirstOrDefault(c => c.ShortDescription == "Curator");
                if (!(attribute is null))
                {
                    attribute.Value = userName;
                }

                //var rndvFmMat = DatabaseContext.RndvFmMat.FirstOrDefault(c => c.RQ == aRequest.ID && c.SP == newSpecification.ID);
                var rndvBomItems = DatabaseContext.RndvBomItem.Where(c => c.SP == newSpecification.ID);
                var rndvFmCPs = DatabaseContext.RndvFmCPs.Where(c => c.RQ == aRequest.ID).ToList();
                rndvFmCPs = rndvFmCPs.Where(c => c.MAT != DatabaseContext.RndvFmCPs.Min(x => x.MAT)).ToList();
                foreach (var rndvBomItem in rndvBomItems)
                {
                    var rndvFmMat = DatabaseContext.RndvFmMat.FirstOrDefault(c => c.ORDER == rndvBomItem.ITEM_NUMBER && c.RQ == aRequest.ID);

                    if (rndvFmMat is null) continue;


                    foreach (var rndvFmCP in rndvFmCPs)
                    {
                        if (rndvFmCP.MAT == rndvFmMat.UNIQUE_ID)
                        {
                            //var auDescription = string.Empty;
                            //var auSeq = 0;
                            if (rndvFmCP.PR_SEQ == 0)
                            {
                                rndvBomItem.MIN_QTY = (decimal)rndvFmCP.QUANTITY;
                                //auDescription = "MinAdmission";
                                //auSeq = 1;
                            }
                            else if (rndvFmCP.PR_SEQ == 1)
                            {
                                rndvBomItem.MAX_QTY = (decimal)rndvFmCP.QUANTITY;
                                //auDescription = "MaxAdmission";
                                //auSeq = 2;
                            }
                            else
                            {
                                continue;
                            }
                            //var rndvAu = DatabaseContext.RndvAu.ToList()
                            //                                   .FirstOrDefault(c => c.SHORT_DESC == auDescription && c.ACTIVE == RnD.Common.Enums.NullableBool.True);
                            //var item = new RndvBomItemAu
                            //{
                            //    SP = (decimal)newSpecification.ID,
                            //    SP_VERSION = (decimal)newSpecification.Version,
                            //    LO = rndvBomItem.LO,
                            //    BOM_USAGE = rndvBomItem.BOM_USAGE,
                            //    ITEM_NUMBER = rndvBomItem.ITEM_NUMBER,
                            //    ICNODE = rndvBomItem.ICNODE,
                            //    IINODE = rndvBomItem.IINODE,
                            //    AU = rndvAu.AU,
                            //    ALTERNATIVE = 1,
                            //    AU_VERSION = rndvAu.VERSION,
                            //    AUSEQ = auSeq,
                            //    VALUE = $"{rndvFmCP.QUANTITY}"
                            //};
                            //DatabaseContext.RndvBomItemAu.Add(item);
                        }
                    }
                }
                DatabaseContext.SaveChanges();
                #endregion

                Log.Warn($"Specification {newSpecification.ID} created!");
            }
            else if (aMaterial.ItemChanged == RnD.Common.Enums.NullableBool.True && aSaveToSpecPref == aUpdateSpecPref)
            {
                aMaterial.ItemChanged = RnD.Common.Enums.NullableBool.False;
                API.FormulaWorkbench.UpdateMaterials(aRequest);
                API.FormulaWorkbench.SaveToSpecification(aMaterial);
                Log.Warn($"Specification {aMaterial.Specification} updated!");
            }
        }
    }
}
