﻿using CheckInfoFields.Services;
using RnD.API;
using RnD.Attributes;
using RnD.Model;
using System;
using System.Linq;

namespace CheckInfoFields.RDnL.Actions
{
    [CustomFunction("CheckInfoFieldsCustomAction", RnD.Common.Enums.CustomFunctionType.CustomAction)]
    public class CheckInfoFieldsCustomAction : AdvancedCustomFunction, ICustomAction<ICustomContext>
    {
        #region Consturctors
        public CheckInfoFieldsCustomAction(IAPI aAPI) : base(aAPI) { }
        #endregion

        #region Methods
        public void Execute(ICustomContext aContext)
        {
            var entity = aContext.Entity;
            var ssFrom = aContext.Event?.EventDetails.FirstOrDefault(c => c.Key == "SS_FROM")?.Value ?? aContext.SS_FROM;   
            if (ssFrom is null)
            {
                Log.Error("ssFrom was null");
                return;
            }
            if(entity is null)
            {
                Log.Error("entity was null");
                return;
            }
            var userId = (decimal)aContext.Event.UserName;
            try

            {
                var infoFields = CheckInfoFieldsService.GetInfoFields(entity);
                var emptyInfoFields = CheckInfoFieldsService.FindEmptyInfoFields(infoFields);

                if (emptyInfoFields.Count() != 0)
                {
                    var statusId = (decimal)ssFrom;
                    var infoFieldNames = CheckInfoFieldsService.GetInfoFieldDisplayTitles(entity, infoFields, DatabaseContext);
                    var notificationMessage = $"Не заполнены необходимые инфополя: {string.Join(", ", infoFieldNames)}";
                    CheckInfoFieldsService.ChangeStatus(entity, statusId, DatabaseContext);
                    CheckInfoFieldsService.SendMessage(userId, notificationMessage, API);
                }
                else
                {
                    return;
                }
            }
            catch (Exception ex)
            {
                Log.Error(ex); 
                CheckInfoFieldsService.SendMessage(userId, ex.Message, API);
            }
        }
        #endregion
    }
}
