﻿using RnD.Messages.Client;
using RnD.Messages.Interfaces.Data;
using System;
using System.Collections.Generic;
using System.Runtime.CompilerServices;

namespace CheckInfoFields.Services
{
    /// <summary>
    /// Service for send message on frontend
    /// </summary>
    internal static class MessageService
    {
        #region Methods
        /// <summary>
        /// Send message to user on RDnL frontend
        /// </summary>
        /// <param name="message">Message for send</param>
        /// <param name="notificationType"></param>
        /// <param name="notificationClient"></param>
        /// <param name="userName"></param>
        /// <param name="db"></param>
        /// <param name="guid"></param>
        public static void SendMessage(in string message, in NotificationType notificationType, in NotificationClient notificationClient,
                                       in string userName, in string db, in Guid guid)
        {
            var notificationMessage = new { Message = message, Arguments = new List<string>() };

            var notification = new Notification
            {
                Data = RuntimeHelpers.GetObjectValue(notificationMessage),
                NotificationType = notificationType
            };
            notificationClient.SendTo(notification, db, userName, guid);
        }
        #endregion
    }
}
