﻿using System.Collections.Generic;
using XmlGenerateFTS.Models.Xml;
using XmlGenerateFTS.Models;

namespace XmlGenerateFTS.Extensions
{
    /// <summary>
    /// Extension for table in FTS xml
    /// </summary>
    public static class TableExtension
    {
        #region Methods
        public static void FillModelMainTable(this Table table, PasportLayoutTableModel pasportLayoutTableModel, List<PasportMainTableModel> pasportMainTableModels)
        {
            table.TableHead = new TableHead { TableRow = new TableRow() };
            table.TableBody = new TableBody { TableRows = new List<TableRow>() };
            if (pasportLayoutTableModel.declarationEAEU.IsNullOrEmpty())
            {
                table.ColumnSpec = new List<string> { "Col1", "Col2", "Col3", "Col4" };
                table.TableHead.TableRow.TableCells = new List<TableCell>
                {
                    new TableCell { TextPara = "Наименование показателей"},
                    new TableCell { TextPara = "Норма НД"},
                    new TableCell { TextPara = "Фактическое значение"},
                    new TableCell { TextPara = "Метод испытаний"},
                };
                pasportMainTableModels.ForEach(mainTable =>
                {
                    table.TableBody.TableRows.Add(
                    new TableRow
                    {
                        TableCells = new List<TableCell>
                        {
                        new TableCell{TextPara = string.Join(" ", mainTable.number, mainTable.DESCRIPTION_RUS).ReplaceRequiredValues()},
                        new TableCell{TextPara = mainTable.NORM_STO_RUS.ReplaceRequiredValues() },
                        new TableCell{TextPara = mainTable.VALUE_RUS.ReplaceRequiredValues() },
                        new TableCell{TextPara = mainTable.METHOD_RUS.ReplaceRequiredValues()},
                        }
                    });
                });
            }
            else
            {
                table.ColumnSpec = new List<string> { "Col1", "Col2", "Col3", "Col4", "Col5" };
                table.TableHead.TableRow.TableCells = new List<TableCell>
                {
                    new TableCell { TextPara = "Наименование показателей"},
                    new TableCell { TextPara = "Норма НД"},
                    new TableCell { TextPara = "Фактическое значение"},
                    new TableCell { TextPara = "Метод испытаний"},
                    new TableCell { TextPara = "ТР ТС 030/2012"},
                };
                pasportMainTableModels.ForEach(mainTable =>
                {
                    table.TableBody.TableRows.Add(
                    new TableRow
                    {
                        TableCells = new List<TableCell>
                        {
                             new TableCell{TextPara = string.Join(" ", mainTable.number, mainTable.DESCRIPTION_RUS).ReplaceRequiredValues()},
                             new TableCell{TextPara = mainTable.NORM_STO_RUS.ReplaceRequiredValues()},
                             new TableCell{TextPara = mainTable.VALUE_RUS.ReplaceRequiredValues()},
                             new TableCell{TextPara = mainTable.METHOD_RUS.ReplaceRequiredValues()},
                             new TableCell{TextPara = mainTable.TP_TC.ReplaceRequiredValues()},
                        }
                    });
                });
            }
            table.Cols = $"{table.ColumnSpec.Count}";
        }
        public static void FillModelSecondTable(this Table table, List<PasportSecondTableModel> pasportSecondTableModels)
        {
            table.TableName = "Показатели качества для определения кодов ТН ВЭД ТС";
            table.ColumnSpec = new List<string> { "Col1", "Col2", "Col3" };
            table.Cols = $"{table.ColumnSpec.Count}";
            table.TableHead = new TableHead
            {
                TableRow = new TableRow
                {
                    TableCells = new List<TableCell>
                    {
                         new TableCell { TextPara = "Наименование показателей"},
                         new TableCell { TextPara = "Фактическое значение"},
                         new TableCell { TextPara = "Метод испытаний"},
                    }
                }
            };
            table.TableBody = new TableBody { TableRows = new List<TableRow>() };
            pasportSecondTableModels.ForEach(secondTable =>
            {
                table.TableBody.TableRows.Add(new TableRow
                {
                    TableCells = new List<TableCell>
                    {
                        new TableCell{TextPara = string.Join(" ", secondTable.number, secondTable.DESCRIPTION_RUS).ReplaceRequiredValues()},
                        new TableCell{TextPara = secondTable.VALUE_RUS.ReplaceRequiredValues()},
                        new TableCell{TextPara = secondTable.METHOD_RUS.ReplaceRequiredValues()},
                    }
                });
            });
        } 
        #endregion
    }

}
