﻿using RnD.Messages.Client;
using RnD.Messages.Interfaces.Data;
using System;

namespace IntegrationFTS.Services
{
    /// <summary>
    /// Service for send message on frontend
    /// </summary>
    public static class MessageService
    {
        #region Methods
        /// <summary>
        /// Send message to user(s) on RDnL frontend
        /// </summary>
        /// <param name="message">Message for send</param>
        /// <param name="notificationType"></param>
        /// <param name="notificationClient"></param>
        /// <param name="userName"></param>
        /// <param name="db"></param>
        /// <param name="guid"></param>
        public static void SendMessage(in string message, in NotificationType notificationType, in NotificationClient notificationClient,
                                       in string userName, in string db, in Guid guid)
        {
            var notification = new Notification
            {
                Data = new { Message = message },
                NotificationType = notificationType
            };
            notificationClient.SendTo(notification, db, userName, guid);
        } 
        #endregion
    }
}
