﻿using System.Collections.Generic;
using System.Linq;

namespace XmlGenerateFTS.Extensions
{
    /// <summary>
    /// Extension for string type
    /// </summary>
    public static class StringExtension
    {
        #region Methods
        public static bool IsNullOrEmpty(this string value) => string.IsNullOrEmpty(value) /*|| value == "-"*/;
        public static string ReplaceRequiredValues(this string line)
        {
            if(line.IsNullOrEmpty()) return string.Empty;

            Dictionary<string, string> chars = new Dictionary<string, string> ();
            chars.Add("≥", ">=");
            chars.Add("≤", "<=");
            chars.Add("²", "2");
            chars.Add("³", "3");

            chars.Where(c => line.Contains(c.Key))
                 .ToList()
                 .ForEach(c => line = line.Replace(c.Key, c.Value));

            return line;
        }
        #endregion
    }
}
