﻿using XmlGenerateFTS.Attributes;

namespace XmlGenerateFTS.Models
{
    public class PasportLayoutTableModel
    {
        #region Properties
        [PropertynName("Проба")]
        public decimal SC { get; set; }
        public decimal locationId { get; set; }
        [PropertynName("Имя продукта")]
        public string productName { get; set; }
        [PropertynName("Номер паспорта")]
        public string passportNumber { get; set; }
        [PropertynName("Нормативный документ")]
        public string regulatoryDocument { get; set; }
        [PropertynName("Предназначение")]
        public string implementation { get; set; }
        [PropertynName("Дата изготовления продукта")]
        public string prodManufacturDate { get; set; }
        [PropertynName("Дата проведения испытаний")]
        public string startEndTestingDate { get; set; }
        [PropertynName("Дата выдачи паспорта")]
        public string passportIssueDate { get; set; }
        [PropertynName("Номер партии")]
        public string batchNumber { get; set; }
        [PropertynName("Вид тары")]
        public string typeOfContainer { get; set; }
        [PropertynName("ОКПД2")]
        public string OKPD2 { get; set; }
        private string _declarationEAEU = string.Empty;
        [PropertynName("Декларация о соответствии продукта ЕАЭС")]
        public string declarationEAEU { get { return $"ЕАЭС {_declarationEAEU}"; } set { _declarationEAEU = value; } }
        [PropertynName("Комментарии тбл.1 RUS")]
        public string remark1 { get; set; }
        [PropertynName("Комментарии тбл.2")]
        public string remark2 { get; set; }
        [PropertynName("Гарантийная информация")]
        public string warranty { get; set; }
        [PropertynName("Особые указания")]
        public string cautionComment { get; set; }
        [PropertynName("Должность пользователя который сформировал ПК")]
        public string userPosition { get; set; }
        [PropertynName("ФИО пользователя который сформировал ПК")]
        public string userFullName { get; set; }
        public string languageName { get; set; } 
        #endregion
    }
}