﻿using System.Xml.Serialization;
using XmlGenerateFTS.Helpers;

namespace XmlGenerateFTS.Models.Xml
{
    [XmlRoot(ElementName = "FreeDoc", Namespace = FreeDocNamespace.InformationCustomsDocumentsFreeDocNamespace)]
    public class FreeDoc
    {
        #region Properties 

        #region Internal 
        [XmlAttribute(AttributeName = "xmlns")]
        public string Xmlns { get; set; }
        [XmlAttribute(AttributeName = "cat_ru", Namespace = FreeDocNamespace.CommonAggregateTypesNamespace)]
        public string CatRu { get; set; }
        [XmlAttribute(AttributeName = "clt_ru", Namespace = FreeDocNamespace.CommonLeafTypesNamespace)]
        public string CltRu { get; set; }
        [XmlAttribute(AttributeName = "CategoryCust", Namespace = FreeDocNamespace.CategoriesNamespace)]
        public string CategoryCust { get; set; }
        [XmlAttribute(AttributeName = "DocumentModeID")]
        public string DocumentModelID { get; set; }
        [XmlAttribute(AttributeName = "DocumentID", Namespace = FreeDocNamespace.CommonAggregateTypesNamespace)]
        public string DocumentID { get; set; }
        #endregion

        #region Extended
        [XmlElement(ElementName = "DocumentHead", Namespace = FreeDocNamespace.InformationCustomsDocumentsFreeDocNamespace)]
        public DocumentHead DocumentHead { get; set; }
        [XmlElement(ElementName = "DocumentBody", Namespace = FreeDocNamespace.InformationCustomsDocumentsFreeDocNamespace)]
        public DocumentBody DocumentBody { get; set; }
        [XmlElement(ElementName = "DocumentSign", Namespace = FreeDocNamespace.InformationCustomsDocumentsFreeDocNamespace)]
        public DocumentSign DocumentSign { get; set; }
        #endregion

        #endregion
    }
}