﻿using RnD.API;
using RnD.Attributes;
using RnD.Common.Enums;
using RnD.Common.Model.ActionBarButtons;
using RnD.CustomFunctionTypes;
using RnD.Model;
using System.Collections.Generic;
using XmlGenerateFTS.Services;

namespace XmlGenerateFTS.RDnL.ActionBarButtons
{
    [CustomFunction("IntegrationFTSCutomActionBar")]
    public class XmlGenerateFTS : AdvancedCustomFunction, ICustomActionBarButton
    {
        #region Consturctor
        public XmlGenerateFTS(IAPI aAPI) : base(aAPI) { }
        #endregion

        #region Methods
        public ActionBarButtonResult Execute(List<ICustomizationObject> aCustomisationObject) => FTSService.ExportFTSButton(aCustomisationObject, API, DatabaseContext);
        public ActionBarButtonMetadata GetActionBarButtonMetadata() => new ActionBarButtonMetadata
        {
            Description = "Передать ПК в ФТС",
            Position = 5,
            IconClass = "icon-cmdXml24",
            DropdownIdentifier = "Экспорт ПК",
            IsVisibleWhen = new List<ActionBarButtonVisibility> { ActionBarButtonVisibility.Sample },
        };
        #endregion
    }
}
