﻿using RnD.API;
using RnD.Attributes;
using RnD.Model;
using XmlGenerateFTS.Services;

namespace XmlGenerateFTS.RDnL.CustomActions
{
    [CustomFunction("XmlGenerateFTSCustomAction", RnD.Common.Enums.CustomFunctionType.CustomAction)]
    public class XmlGenerateFTSCustomAction : AdvancedCustomFunction, ICustomAction<ICustomContext>
    {
        #region Constructor
        public XmlGenerateFTSCustomAction(IAPI aAPI) : base(aAPI) { }

        #endregion

        #region Methods
        public void Execute(ICustomContext aContext) => FTSService.ExportFTSAction(aContext.Entity, API, DatabaseContext);

        #endregion
    }
}
