﻿using IntegrationS4.RDnL.Services;
using RnD.API;
using RnD.Attributes;
using RnD.Common.Enums;
using RnD.Common.Model.ActionBarButtons;
using RnD.CustomFunctionTypes;
using RnD.Model;
using System.Collections.Generic;
using System.Linq;

namespace IntegrationS4.RDnL.Buttons
{
    [CustomFunction("IntegrationS4CustomActionBar")]

    public class IntegrationS4Button : AdvancedCustomFunction, ICustomActionBarButton
    {
        public IntegrationS4Button(IAPI aAPI) : base(aAPI)
        {
        }

        public ActionBarButtonResult Execute(List<ICustomizationObject> aCustomisationObject)
        {
            var userId = API.CustomizationSession.User.ID;
            //if(userId != 449 || userId != 450)
            //{
            //    return new ActionBarButtonResult { Message = "Invalid user", MessageType = MessageType.Error };
            //}

            var specification = aCustomisationObject.FirstOrDefault(c => c is ISpecification) as ISpecification;
            if (specification is null)
            {
                Log.Error("Specification for sending is null");
                return new ActionBarButtonResult { Message = "Specification for sending is null", MessageType = MessageType.Error };
            }
            var request = IntegrationS4Service.ExportS4(specification);
            return request;
        }

        public ActionBarButtonMetadata GetActionBarButtonMetadata() => new ActionBarButtonMetadata
        {
            Description = "Передать в S4",
            Position = 5,
            IconClass = "icon-cmdXml24",
            DropdownIdentifier = "",
            IsVisibleWhen = new List<ActionBarButtonVisibility> { ActionBarButtonVisibility.Specification },
        };
    }
}
