﻿using IntegrationS4.RDnL.Services.Soap;
using RnD.Common.Enums;
using RnD.Common.Model.ActionBarButtons;
using RnD.Model;
using System;
using System.ServiceModel.Channels;
using System.ServiceModel;
using System.Threading.Tasks;
using System.ServiceModel.Web;
using System.Net;

namespace IntegrationS4.RDnL.Services
{
    public static class IntegrationS4Service
    {
        public static ActionBarButtonResult ExportS4(ISpecification specification)
        {
            try
            {
                SIOpCenterSendAOClient sIOpCenterSendAOClient = new SIOpCenterSendAOClient(EndpointConfiguration.HttpPort);
                using (var context = new OperationContextScope(sIOpCenterSendAOClient.InnerChannel))
                {
                    HttpRequestMessageProperty requestMessage = new HttpRequestMessageProperty();
                    requestMessage.Headers["Authorization"] = "Basic RVNCX09QQ0VOVEVSOk9ZMSQlOWdj";
                    OperationContext.Current.OutgoingMessageProperties[HttpRequestMessageProperty.Name] = requestMessage;

                    var dtBOMCreate = new DTBOMCreate
                    {
                        SystemReceiver = "S4",
                        SystemSender = "Opcenter RDnL",
                        GuidMsgExt = Guid.NewGuid().ToString(),
                        Document = new DTBOMCreateDocument[]
    {
                        new DTBOMCreateDocument
                        {
                            ID = "1141",
                            STLAL = "1",
                            STLST = "33",
                            WERKS = "2420",
                            AENNR = "1",
                            BMEIN = "кг",
                            BMENG = "100,000",
                            DATUB = "31.12.9999",
                            DATUV = "04.04.2023",
                            MATNR = "1440405",
                            Item = new DTBOMCreateDocumentItem[]
                            {
                                new DTBOMCreateDocumentItem
                                {
                                    MEINS = "кг",
                                    POSNR = "10",
                                    FMENG = "B",
                                    IDNRK = "3142093",
                                    MENGE = "80.000000",
                                    POTX1 = "0-0",
                                },
                                new DTBOMCreateDocumentItem
                                {
                                    MEINS = "кг",
                                    POSNR = "20",
                                    FMENG = "B",
                                    IDNRK = "1678971",
                                    MENGE = "20.000000",
                                    POTX1 = "0-0",
                                }
                            }
                        }
    },
                    };

                    sIOpCenterSendAOClient.BOMCreateAsync(dtBOMCreate).Wait();
                }
            }
            catch (Exception ex)
            {
                return new ActionBarButtonResult { Message = $"{ex.Message}", MessageType = MessageType.Error };
            }


            return new ActionBarButtonResult { Message = $"Успешная отправка", MessageType = MessageType.Information };
        }
    }
}
