﻿using System;
using System.ComponentModel;
using System.Net;
using System.ServiceModel;
using System.ServiceModel.Channels;
using System.ServiceModel.Description;
using System.Threading.Tasks;
using System.Xml;

namespace IntegrationS4.RDnL.Services.Soap
{

    [System.Diagnostics.DebuggerStepThroughAttribute()]
    [System.CodeDom.Compiler.GeneratedCodeAttribute("Microsoft.Tools.ServiceModel.Svcutil", "2.1.0")]
    public partial class SIOpCenterSendAOClient : ClientBase<ISIOpCenterSendAO>, ISIOpCenterSendAO
    {

        /// <summary>
        /// Implement this partial method to configure the service endpoint.
        /// </summary>
        /// <param name="serviceEndpoint">The endpoint to configure</param>
        /// <param name="clientCredentials">The client credentials</param>
        static partial void ConfigureEndpoint(ServiceEndpoint serviceEndpoint, ClientCredentials clientCredentials);

        public SIOpCenterSendAOClient(EndpointConfiguration endpointConfiguration) :
                base(SIOpCenterSendAOClient.GetBindingForEndpoint(endpointConfiguration), SIOpCenterSendAOClient.GetEndpointAddress(endpointConfiguration))
        {
            this.Endpoint.Name = endpointConfiguration.ToString();
            ConfigureEndpoint(this.Endpoint, this.ClientCredentials);
        }

        public SIOpCenterSendAOClient(EndpointConfiguration endpointConfiguration, string remoteAddress) :
                base(SIOpCenterSendAOClient.GetBindingForEndpoint(endpointConfiguration), new System.ServiceModel.EndpointAddress(remoteAddress))
        {
            this.Endpoint.Name = endpointConfiguration.ToString();
            ConfigureEndpoint(this.Endpoint, this.ClientCredentials);
        }

        public SIOpCenterSendAOClient(EndpointConfiguration endpointConfiguration, EndpointAddress remoteAddress) :
                base(SIOpCenterSendAOClient.GetBindingForEndpoint(endpointConfiguration), remoteAddress)
        {
            this.Endpoint.Name = endpointConfiguration.ToString();
            ConfigureEndpoint(this.Endpoint, this.ClientCredentials);
        }

        public SIOpCenterSendAOClient(Binding binding, EndpointAddress remoteAddress) :
                base(binding, remoteAddress)
        {
        }

        [EditorBrowsableAttribute(EditorBrowsableState.Advanced)]
        Task ISIOpCenterSendAO.QmResultAsync(QmResult request)
        {
            return base.Channel.QmResultAsync(request);
        }

        public Task QmResultAsync(DTQmResult MT_QmResult)
        {
            QmResult inValue = new QmResult();
            inValue.MT_QmResult = MT_QmResult;
            return ((ISIOpCenterSendAO)(this)).QmResultAsync(inValue);
        }

        [EditorBrowsableAttribute(EditorBrowsableState.Advanced)]
        Task ISIOpCenterSendAO.InspMAsync(InspM request)
        {
            return base.Channel.InspMAsync(request);
        }

        public Task InspMAsync(DTInspM MT_InspM)
        {
            InspM inValue = new InspM();
            inValue.MT_InspM = MT_InspM;
            return ((ISIOpCenterSendAO)(this)).InspMAsync(inValue);
        }

        [EditorBrowsableAttribute(EditorBrowsableState.Advanced)]
        Task ISIOpCenterSendAO.PassAsync(Pass request)
        {
            return base.Channel.PassAsync(request);
        }

        public Task PassAsync(DTPass MT_Pass)
        {
            Pass inValue = new Pass();
            inValue.MT_Pass = MT_Pass;
            return ((ISIOpCenterSendAO)(this)).PassAsync(inValue);
        }

        [EditorBrowsableAttribute(EditorBrowsableState.Advanced)]
        Task ISIOpCenterSendAO.MICAsync(MIC request)
        {
            return base.Channel.MICAsync(request);
        }

        public Task MICAsync(DTMIC MT_MIC)
        {
            MIC inValue = new MIC();
            inValue.MT_MIC = MT_MIC;
            return ((ISIOpCenterSendAO)(this)).MICAsync(inValue);
        }

        [EditorBrowsableAttribute(EditorBrowsableState.Advanced)]
        Task ISIOpCenterSendAO.BOMCreateAsync(BOMCreate request)
        {
            return base.Channel.BOMCreateAsync(request);
        }

        public Task BOMCreateAsync(DTBOMCreate MT_BOMCreate)
        {
            BOMCreate inValue = new BOMCreate();
            inValue.MT_BOMCreate = MT_BOMCreate;
            return ((ISIOpCenterSendAO)(this)).BOMCreateAsync(inValue);
        }

        [EditorBrowsableAttribute(EditorBrowsableState.Advanced)]
        Task ISIOpCenterSendAO.ProbeDAsync(ProbeD request)
        {
            return base.Channel.ProbeDAsync(request);
        }

        public Task ProbeDAsync(DTProbeD MT_ProbeD)
        {
            ProbeD inValue = new ProbeD();
            inValue.MT_ProbeD = MT_ProbeD;
            return ((ISIOpCenterSendAO)(this)).ProbeDAsync(inValue);
        }

        [EditorBrowsableAttribute(EditorBrowsableState.Advanced)]
        Task ISIOpCenterSendAO.ConfirmationAsync(Confirmation request)
        {
            return base.Channel.ConfirmationAsync(request);
        }

        public Task ConfirmationAsync(DTConfirmation MT_Confirmation)
        {
            Confirmation inValue = new Confirmation();
            inValue.MT_Confirmation = MT_Confirmation;
            return ((ISIOpCenterSendAO)(this)).ConfirmationAsync(inValue);
        }

        [EditorBrowsableAttribute(EditorBrowsableState.Advanced)]
        Task ISIOpCenterSendAO.ProbeAsync(Probe request)
        {
            return base.Channel.ProbeAsync(request);
        }

        public Task ProbeAsync(DTProbe MT_Probe)
        {
            Probe inValue = new Probe();
            inValue.MT_Probe = MT_Probe;
            return ((ISIOpCenterSendAO)(this)).ProbeAsync(inValue);
        }

        public virtual Task OpenAsync()
        {
            return Task.Factory.FromAsync(((ICommunicationObject)(this)).BeginOpen(null, null), new Action<IAsyncResult>(((ICommunicationObject)(this)).EndOpen));
        }

        private static Binding GetBindingForEndpoint(EndpointConfiguration endpointConfiguration)
        {
            if ((endpointConfiguration == EndpointConfiguration.HttpPort))
            {
                BasicHttpBinding result = new BasicHttpBinding();
                result.MaxBufferSize = int.MaxValue;
                result.ReaderQuotas = XmlDictionaryReaderQuotas.Max;
                result.MaxReceivedMessageSize = int.MaxValue;
                result.AllowCookies = true;
                return result;
            }
            if ((endpointConfiguration == EndpointConfiguration.HttpsPort))
            {
                BasicHttpBinding result = new BasicHttpBinding();
                result.MaxBufferSize = int.MaxValue;
                result.ReaderQuotas = XmlDictionaryReaderQuotas.Max;
                result.MaxReceivedMessageSize = int.MaxValue;
                result.AllowCookies = true;
                result.Security.Mode = System.ServiceModel.BasicHttpSecurityMode.Transport;
                return result;
            }
            throw new System.InvalidOperationException(string.Format("Could not find endpoint with name \'{0}\'.", endpointConfiguration));
        }

        private static EndpointAddress GetEndpointAddress(EndpointConfiguration endpointConfiguration)
        {
            if ((endpointConfiguration == EndpointConfiguration.HttpPort))
            {
                return new EndpointAddress("http://sapx62cidb.srv.lukoil.com/XISOAPAdapter/MessageServlet?senderParty=&sende" +
                                           "rService=BSD_OPCENTER&receiverParty=&receiverService=&interface=SI_OpCenterSend_" +
                                           "AO&interfaceNamespace=http%3A%2F%2Flukoil.ru%2Fopcenter%2FORM");
            }
            if ((endpointConfiguration == EndpointConfiguration.HttpsPort))
            {
                return new EndpointAddress("https://sapx62cidb.srv.lukoil.com/XISOAPAdapter/MessageServlet?senderParty=&sende" +
                                                   "rService=BSD_OPCENTER&receiverParty=&receiverService=&interface=SI_OpCenterSend_" +
                                                   "AO&interfaceNamespace=http%3A%2F%2Flukoil.ru%2Fopcenter%2FORM");

            }
            throw new InvalidOperationException(string.Format("Could not find endpoint with name \'{0}\'.", endpointConfiguration));
        }


    }
}
