﻿using IntegrationKSSS.WebService.Infrastructure.Models;
using Microsoft.EntityFrameworkCore;

namespace IntegrationKSSS.WebService.Infrastructure.Data
{
    public class RDnLDbContext : DbContext
    {
        public RDnLDbContext(DbContextOptions dbContextOptions) : base(dbContextOptions) {}

        public DbSet<RndtSp> RndtSp => Set<RndtSp>();
        public DbSet<RndtSpIc> RndtSpIc => Set<RndtSpIc>();
        public DbSet<RndtSpIi> RndtSpIi => Set<RndtSpIi>();

        protected override void OnModelCreating(ModelBuilder modelBuilder)
        {
            modelBuilder.HasDefaultSchema("RndSuite");

            modelBuilder.Entity<RndtSp>()
                        .HasKey(c => new { c.SP, c.SP_VERSION });

            modelBuilder.Entity<RndtSpIc>()
                        .HasKey(c => new { c.SP, c.SP_VERSION, c.IC, c.ICNODE});

            modelBuilder.Entity<RndtSpIi>()
                        .HasKey(c => new {c.SP, c.SP_VERSION, c.IC, c.ICNODE, c.IINODE});        
        }
    }
}
