﻿using IntegrationKSSS.Models;
using IntegrationKSSS.WebService.Infrastructure.Data;
using ILogger = NLog.ILogger;

namespace IntegrationKSSS.WebService.Infrastructure.Repositories
{
    public class KsssRepository : KsssRepositoryBase, IKsssRepository
    {
        public KsssRepository(RDnLDbContext rDnLDbContext, ILogger logger) : base(rDnLDbContext, logger) { }

        public async Task<string> WriteKsssData(Dictionary<string, string> ksssDictionary)
        {
            decimal specificationId = 0;
            decimal.TryParse(ksssDictionary["SP"], out specificationId);
            if(specificationId == 0)
            {
                Logger.Info("Not found specification id");
                return "Not found specification id";
            }
            decimal ssDev = 1000012;
            string nameInfoCard = "KSSS_Data";

            var specification = RDnLDbContext.RndtSp.FirstOrDefault(c => c.SP == specificationId &&
                                                                    c.ALLOW_MODIFY == '1' &&
                                                                    c.SS == ssDev);


            if (specification == null)
            {
                Logger.Info($"Not found specification {specificationId}");
                return $"Not found specification {specificationId}";
            }


            var infoCardKsss = RDnLDbContext.RndtSpIc.FirstOrDefault(infoCard => infoCard.SP == specification.SP &&
                                                                     infoCard.IC_SHORT_DESC == nameInfoCard &&
                                                                     infoCard.SP_VERSION == specification.SP_VERSION);

            if(infoCardKsss == null)
            {
                Logger.Info($"Not found info card {nameInfoCard}");
                return $"Not found info card {nameInfoCard}";
            }

            var infoFields = RDnLDbContext.RndtSpIi.Where(infoField => infoField.IC == infoCardKsss.IC &&
                                                          infoField.SP == specificationId);

            

            if(infoFields.Count() == 0)
            {
                Logger.Info($"There are no info fields on the info card {nameInfoCard}");
                return $"There are no info fields on the info card {nameInfoCard}";
            }
            
            foreach (var ksssValuePair in ksssDictionary)
            {
                if(ksssValuePair.Key == "SP")
                {
                    continue;
                }

                var foundedInfoField = infoFields.FirstOrDefault(infoField => infoField.II_SHORT_DESC == ksssValuePair.Key);
                if(foundedInfoField == null)
                {
                    continue;
                }
                foundedInfoField.IIVALUE = ksssValuePair.Value;
            }
            await RDnLDbContext.SaveChangesAsync();
            Logger.Info($"Successfully recorded data on the info card {nameInfoCard}");
            return $"Successfully recorded data on the info card {nameInfoCard}";
        }
    }
}
