﻿using IntegrationKSSS.WebService.Infrastructure.RequestHandlers;

namespace IntegrationKSSS.WebService.Infrastructure.RouteHandlers
{
    public interface IRouteHandler
    {
        void Register(WebApplication webApplication);
    }
    public abstract class KsssRouteHandlerBase
    {
        internal WebApplication WebApplication { get; set; }
    }
    public class RouteHandler : KsssRouteHandlerBase, IRouteHandler
    {
        public void Register(WebApplication webApplication)
        {
            WebApplication = webApplication;
            Creators();
        }

        private void Creators()
        {
            WebApplication.MapPost("/api/ksss", KsssFunctions.WriteKsssData());
        }
    }
}
