﻿using IntegrationKSSS.Models;
using IntegrationKSSS.Services;
using RnD.API;
using RnD.Attributes;
using RnD.Common.Enums;
using RnD.Common.Model.ActionBarButtons;
using RnD.CustomFunctionTypes;
using RnD.Model;
using System.Collections.Generic;
using System.Linq;

namespace IntegrationKSSS.RDnL.ActionBarButtons
{
    [CustomFunction("IntegrationKSSSutomActionBar")]
    public class ExportKsssActionBarButton : AdvancedCustomFunction, ICustomActionBarButton
    {
        #region Constructors
        public ExportKsssActionBarButton(IAPI aAPI) : base(aAPI) { }

        #endregion

        #region Methods
        public ActionBarButtonResult Execute(List<ICustomizationObject> aCustomisationObject)
        {
            if (!(aCustomisationObject.FirstOrDefault(c => c is ISpecification) is ISpecification specificationEntity))
            {
                return new ActionBarButtonResult
                {
                    Message = MessageList.ObjectNotSpecification.Rus,
                    MessageType = MessageList.ObjectNotSpecification.Type
                };
            }
            var specification = API.Specification.GetSpecification(specificationEntity.ID, specificationEntity.Version);
            return KsssService.ExportKsss(specification);
        }

        public ActionBarButtonMetadata GetActionBarButtonMetadata() => new ActionBarButtonMetadata
        {
            Description = "Передать ПК в КССС",
            Position = 0,
            IconClass = "icon-cmdJson24",
            DropdownIdentifier = "",
            IsVisibleWhen = new List<ActionBarButtonVisibility> { ActionBarButtonVisibility.Specification },
        };
        #endregion
    }
}
