﻿using IntegrationKSSS.WebService.Infrastructure.Models;
using IntegrationKSSS.WebService.Infrastructure.Repositories;
using Microsoft.AspNetCore.Authorization;

namespace IntegrationKSSS.WebService.Infrastructure.RequestHandlers;

internal static class RequestHandler
{
    /// <summary>
    /// KSSS data recording function
    /// </summary>
    /// <returns></returns>
    #region Methods
    internal static Func<IKsssRepository, Dictionary<string, string>, Task<IResult>> WriteKsssData()
    {
        return [Authorize] async (IKsssRepository ksssRepository, Dictionary<string, string> ksss) =>
        {
            await ksssRepository.WriteKsssData(ksss);
            return Results.Accepted("/api/ksss", MessageList.AcceptedDataPackage);
        };
    } 
    #endregion
}