﻿using IntegrationKSSS.Models;
using IntegrationKSSS.Services;
using RnD.API;
using RnD.Attributes;
using RnD.Common.Enums;
using RnD.Common.Model.ActionBarButtons;
using RnD.CustomFunctionTypes;
using RnD.Model;
using System.Collections.Generic;
using System.Linq;

namespace IntegrationKSSS.RDnL.ActionBarButtons
{
    /// <summary>
    /// Custom export KSSS button class
    /// </summary>
    [CustomFunction("IntegrationKSSSutomActionBar")]
    public class ExportKsssActionBarButton : AdvancedCustomFunction, ICustomActionBarButton
    {
        #region Constructors
        public ExportKsssActionBarButton(IAPI aAPI) : base(aAPI) { }

        #endregion

        #region Methods
        /// <summary>
        /// On click button event
        /// </summary>
        /// <param name="aCustomisationObject"></param>
        /// <returns></returns>
        public ActionBarButtonResult Execute(List<ICustomizationObject> aCustomisationObject)
        {
            if (!(aCustomisationObject.FirstOrDefault(c => c is ISpecification) is ISpecification specificationEntity))
            {
                return new ActionBarButtonResult
                {
                    Message = MessageList.ObjectNotSpecification.Rus,
                    MessageType = MessageList.ObjectNotSpecification.Type
                };
            }
            var specification = API.Specification.GetSpecification(specificationEntity.ID, specificationEntity.Version);
            
            return KsssService.ExportKsss(specification, DatabaseContext);
        }
        /// <summary>
        /// Button properties
        /// </summary>
        /// <returns></returns>
        public ActionBarButtonMetadata GetActionBarButtonMetadata() => new ActionBarButtonMetadata
        {
            Description = "Передать ПК в КССС",
            Position = 0,
            IconClass = "icon-cmdJson24",
            DropdownIdentifier = "",
            IsVisibleWhen = new List<ActionBarButtonVisibility> { ActionBarButtonVisibility.Specification },
        };
        #endregion
    }
}
