﻿using Newtonsoft.Json;
using System.Collections.Generic;

namespace IntegraitonR3.Models
{
    /// <summary>
    /// R3 data model
    /// </summary>
    public class R3
    {
        [JsonProperty("Idpcmag")]
        public int Idpcmag { get; set; }

        [JsonProperty("IdPNPMag")]
        public int IdPNPMag { get; set; }

        [JsonProperty("KSSS")]
        public string KSSS { get; set; }

        [JsonProperty("Idunomenc")]
        public int ProductCode { get; set; }

        [JsonProperty("NameNomenc")]
        public string ProductName { get; set; }

        [JsonProperty("DocDateStr")]
        public string PassportIssueDate { get; set; }

        [JsonProperty("Docnumber")]
        public string PassportNumber { get; set; }

        //[JsonProperty("BatchNumber")]
        //public string BatchNumber { get; set; }

        [JsonProperty("Doctype")]
        public string DocumentType { get; set; }

        [JsonProperty("DocMode")]
        public int DocumentMode { get; set; }

        [JsonProperty("Idudate")]
        public int SampleCode { get; set; }

        [JsonProperty("Status")]
        public string Status { get; set; }

        [JsonProperty("Fio")]
        public string FullName { get; set; }

        [JsonProperty("Qualities")]
        public List<R3Qualitiy> Qualities { get; set; } = new List<R3Qualitiy>();
    }
}
